# RevPlan OData Middleware

A Next.js middleware layer for FileMaker OData services with ESLint and SWC compatibility

This is a [Next.js](https://nextjs.org) project bootstrapped with [`create-next-app`](https://nextjs.org/docs/app/api-reference/cli/create-next-app) that provides a middleware layer between clients and FileMaker OData services.

## Deployment Status

Last updated: June 14, 2025 - Fixed ESLint and SWC compatibility issues for Vercel deployment.

## Getting Started

First, run the development server:

```bash
npm run dev
# or
yarn dev
# or
pnpm dev
# or
bun dev
```

Open [http://localhost:3000](http://localhost:3000) with your browser to see the result.

You can start editing the page by modifying `app/page.tsx`. The page auto-updates as you edit the file.

## Project Overview

This application serves as a middleware layer between client applications and FileMaker OData services. It uses a hardcoded approach for database, table, and field configurations to ensure type safety, maintainability, and clarity.

### Key Features

- **Hardcoded Configuration**: Type-safe database, table, and field definitions
- **OData Client**: Handles communication with FileMaker OData endpoints
- **API Routes**: RESTful interface for CRUD operations
- **React Integration**: Context and hooks for component-level data access

### Documentation

For detailed architecture documentation, see [ARCHITECTURE.md](./docs/ARCHITECTURE.md).

### Environment Variables

Create a `.env.local` file with the following variables:

```
FILEMAKER_ODATA_URL1=https://your-filemaker-server.com/fmi/odata/v4/your-database
FILEMAKER_USERNAME1=your-username
FILEMAKER_PASSWORD1=your-password
NEXT_PUBLIC_API_URL=/api/odata
```

This project uses [`next/font`](https://nextjs.org/docs/app/building-your-application/optimizing/fonts) to automatically optimize and load [Geist](https://vercel.com/font), a new font family for Vercel.

## Learn More

To learn more about Next.js, take a look at the following resources:

- [Next.js Documentation](https://nextjs.org/docs) - learn about Next.js features and API.
- [Learn Next.js](https://nextjs.org/learn) - an interactive Next.js tutorial.

You can check out [the Next.js GitHub repository](https://github.com/vercel/next.js) - your feedback and contributions are welcome!

## Deploy on Vercel

The easiest way to deploy your Next.js app is to use the [Vercel Platform](https://vercel.com/new?utm_medium=default-template&filter=next.js&utm_source=create-next-app&utm_campaign=create-next-app-readme) from the creators of Next.js.

Check out our [Next.js deployment documentation](https://nextjs.org/docs/app/building-your-application/deploying) for more details.
